package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.MedianWaitTime;
import gov.va.vinci.dart.db.util.CallableStatementDAO;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MedianWaitTimeDAO extends CallableStatementDAO<MedianWaitTime> {
	private String requestTypeStr;
	
	public MedianWaitTimeDAO(final String requestTypeStr) {
		this.requestTypeStr  = requestTypeStr;
	}
	
	public String getQueryText() {
		return "{call ws.GetMedianWaittimes(?)}";
	}
	
	public void populateParameters(final CallableStatement cstmt) throws SQLException {
		cstmt.setString(1, requestTypeStr);
	}
	
	public MedianWaitTime buildResult(final ResultSet rs) throws SQLException {
        MedianWaitTime medianWaitTime = new MedianWaitTime();
        
        medianWaitTime.setMetric( rs.getString(1).trim() );
        
        medianWaitTime.setRequestorMedian( rs.getFloat(2) );
        medianWaitTime.setReviewerMedian( rs.getFloat(3) );
        
        return medianWaitTime;
	}
}
